using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using System.CodeDom;
using Borland.Studio.ToolsAPI;
using BeWise.SharpBuilderTools.Utils;

namespace BeWise.SharpBuilderTools.Gui
{

	public class FrmViewMethods : FrmBaseView
	{
		/**************************************************************/
		/*                        Protected
		/**************************************************************/

		protected override ListViewItem CreateListViewItem(object aItem) {
			ListViewItem _ListViewItem = new ListViewItem();

			MethodInfo _MethodInfo = (MethodInfo) aItem;

			_ListViewItem.Text = _MethodInfo.ClassName;
			_ListViewItem.SubItems.Add(_MethodInfo.CodeMemberMethod.Name);
			_ListViewItem.Tag = aItem;

			return _ListViewItem;
		}

		protected override void ExecuteItem(object aItem) {
			MethodInfo _MethodInfo = (MethodInfo) aItem;

			_MethodInfo.Goto();
		}

		protected override string GetFormText() {
			return "View Methods";
		}

		protected override string GetLabelText(){
			return "Method name:";
		}

		protected override string GetTabPageText(){
			return "Methods";
		}

		protected override bool ItemIsVisible(string aFilter, object aItem) {
			if (aFilter == "") {
				return true;
			}
			else {
				MethodInfo _MethodInfo = (MethodInfo) aItem;

				return ((_MethodInfo.CodeMemberMethod.Name.ToUpper()).IndexOf(aFilter.ToUpper()) > -1);
			}
		}

		protected override void InitializeListView(ListView aListView) {
			base.InitializeListView(aListView);

			aListView.Columns[0].Text = "Class Name";
			aListView.Columns[0].Width = 100;
			ColumnHeader _Col = new ColumnHeader();
			_Col.Text = "Method Name";
			_Col.Width = aListView.Width -4 - 100;

			aListView.Columns.Add(_Col);
		}            


		/**************************************************************/
		/*                        Public
		/**************************************************************/

		public override int Compare(object x, object y) {
			MethodInfo _MethodInfoX = (MethodInfo) x;
			MethodInfo _MethodInfoY = (MethodInfo) y;

			int _Comp = String.Compare(_MethodInfoX.ClassName, _MethodInfoY.ClassName);

			if (_Comp == 0) {
				_Comp = String.Compare(_MethodInfoX.CodeMemberMethod.Name, _MethodInfoY.CodeMemberMethod.Name);
			}

			return _Comp;
		}

		public override void LoadItems() {
			OTAUtils.LoadMethodInfoInList(Items);
		}

	}
}
